/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.plugin;

import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.github.monun.survival.Survival;
import com.github.monun.survival.SurvivalConfig;
import com.github.monun.survival.SurvivalKt;
import com.github.monun.survival.Whitelist;
import com.github.monun.survival.plugin.EventListenerKt;
import io.papermc.paper.event.player.AsyncChatEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020 H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Lcom/github/monun/survival/plugin/EventListener;", "Lorg/bukkit/event/Listener;", "survival", "Lcom/github/monun/survival/Survival;", "(Lcom/github/monun/survival/Survival;)V", "onAsyncPlayerChat", "", "event", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onAsyncPlayerPreLogin", "Lorg/bukkit/event/player/AsyncPlayerPreLoginEvent;", "onBlockBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onCreatureSpawn", "Lcom/destroystokyo/paper/event/entity/PlayerNaturallySpawnCreaturesEvent;", "onEntityDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onInventoryPickup", "Lorg/bukkit/event/inventory/InventoryPickupItemEvent;", "onPlayerCommandPreprocess", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerItemConsume", "Lorg/bukkit/event/player/PlayerItemConsumeEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "onServerListPing", "Lcom/destroystokyo/paper/event/server/PaperServerListPingEvent;"})
public final class EventListener
implements Listener {
    private final Survival survival;

    @EventHandler
    public final void onAsyncPlayerPreLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string2 = event.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.name");
        String name = string2;
        if (SurvivalConfig.INSTANCE.getDefaultHumans().contains(name) || Whitelist.INSTANCE.getAllows().contains(name)) {
            return;
        }
        event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)Component.text((String)"\ub2e4\uc74c \uae30\ud68c\uc5d0 \u315c\u315c"));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"event.player");
        Player player3 = player2;
        if (!player3.hasPlayedBefore()) {
            World world = player3.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"player.world");
            WorldBorder worldBorder = world.getWorldBorder();
            Intrinsics.checkNotNullExpressionValue((Object)worldBorder, (String)"player.world.worldBorder");
            Location location = worldBorder.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"player.world.worldBorder.center");
            player3.teleport(EventListenerKt.random(location, SurvivalConfig.INSTANCE.getWorldSize() / 2.0));
        }
        Player player4 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"event.player");
        this.survival.loadPlayer$survival(player4);
        event.joinMessage(null);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"event.player");
        this.survival.unloadPlayer$survival(player2);
        event.quitMessage(null);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onAsyncPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.setCancelled(false);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"event.player");
        if (!player2.isOp()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerRespawn(@NotNull PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Location location = event.getRespawnLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.respawnLocation");
        Location loc = location;
        World world = loc.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"loc.world");
        WorldBorder worldBorder = world.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue((Object)worldBorder, (String)"loc.world.worldBorder");
        Location location2 = worldBorder.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"loc.world.worldBorder.center");
        event.setRespawnLocation(EventListenerKt.random(location2, SurvivalConfig.INSTANCE.getWorldSize() / 2.0));
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.deathMessage(null);
    }

    @EventHandler
    public final void onServerListPing(@NotNull PaperServerListPingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.setHidePlayers(true);
        event.setMaxPlayers(0);
        event.setNumPlayers(0);
        event.motd((Component)((TextComponent.Builder)Component.text().color(TextColor.color((int)0xDD0000))).content(ChatColor.BOLD + "S U R V I V A L").build());
    }

    @EventHandler(ignoreCancelled=true)
    public final void onEntityDamage(@NotNull EntityDamageEvent event) {
        ItemMeta bootsMeta;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.entity");
        Entity entity2 = entity;
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        EntityEquipment entityEquipment = ((LivingEntity)entity2).getEquipment();
        ItemStack boots = entityEquipment != null ? entityEquipment.getBoots() : null;
        double bootsDamage = event.getDamage() * SurvivalConfig.INSTANCE.getBootsFallDamage();
        if (boots != null && (bootsMeta = boots.getItemMeta()) instanceof Damageable) {
            Material material = boots.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"boots.type");
            short maxDurability = material.getMaxDurability();
            int currentDurability = ((Damageable)bootsMeta).getDamage();
            int remainDurability = maxDurability - currentDurability;
            int n = (int)bootsDamage;
            boolean bl = false;
            int reduce = Math.min(remainDurability, n);
            bootsDamage -= (double)reduce;
            Damageable damageable = (Damageable)bootsMeta;
            damageable.setDamage(damageable.getDamage() + reduce);
            boots.setItemMeta(bootsMeta);
            if (((Damageable)bootsMeta).getDamage() >= maxDurability) {
                boots.setAmount(0);
            }
        }
        if (bootsDamage > 0.0) {
            ((LivingEntity)entity2).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)(bootsDamage / SurvivalConfig.INSTANCE.getBootsFallDamage()) * 20, SurvivalConfig.INSTANCE.getBootsFallSlow(), true, true, true));
        }
        event.setDamage(0.0);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onInventoryPickup(@NotNull InventoryPickupItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Item item = event.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"event.item");
        ItemStack itemStack = item.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"event.item.itemStack");
        if (itemStack.getType() == Material.TOTEM_OF_UNDYING) {
            Inventory inventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"event.inventory");
            if (inventory.getType() == InventoryType.HOPPER) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onCreatureSpawn(@NotNull PlayerNaturallySpawnCreaturesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"event.player");
        if (SurvivalKt.survival(player2).getBio() instanceof Zombie) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"event.block");
        if (block.getType() == Material.SPAWNER) {
            Player player2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"event.player");
            if (SurvivalKt.survival(player2).getBio() instanceof Zombie) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack itemStack = event.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"event.item");
        if (itemStack.getType() == Material.MILK_BUCKET) {
            event.setCancelled(true);
        }
    }

    public EventListener(@NotNull Survival survival) {
        Intrinsics.checkNotNullParameter((Object)survival, (String)"survival");
        this.survival = survival;
    }
}

